import nodemailer from "nodemailer";
import { config } from "dotenv";

config();

const sendEmail = async (to, subject, html, fromName) => {
  try {
    const transporter = nodemailer.createTransport({
      sendmail: true,
      newline: "unix",
      path: "/sbin/sendmail",
    });

    const displayName = fromName;

    const mailOptions = {
      from: `"${displayName}" <${process.env.FROM_EMAIL}>`,
      to,
      subject,
      html,
    };

    const info = await transporter.sendMail(mailOptions);
    return info;
  } catch (error) {
    console.error("Error sending email:", error);
    throw error;
  }
};

export default sendEmail;
