import express from "express";
import cors from "cors";
import fileUpload from "express-fileupload";
import { config } from "dotenv";
import cloudinary from "cloudinary";
import contactRoute from "./route/contact.route.js";
import careerRoute from "./route/career.route.js";

const app = express();
config();

const PORT = process.env.PORT || 3001;

cloudinary.v2.config({
  cloud_name: process.env.CLOUDINARY_CLOUD_NAME,
  api_key: process.env.CLOUDINARY_API_KEY,
  api_secret: process.env.CLOUDINARY_API_SECRET,
});

app.use(
  cors({
    origin: [process.env.FRONTEND_URL],
    methods: ["POST", "GET", "PUT", "DELETE"],
    credentials: true,
  })
);
app.use(express.json());
app.use(
  fileUpload({
    useTempFiles: true,
    tempFileDir: "/tmp/",
  })
);

app.use("/contact", contactRoute);
app.use("/career", careerRoute);

app.listen(PORT, () => {
  console.log(`server is listening on port ${PORT}`);
});
