import sendEmail from "../utils/sendEmail.js";
import { config } from "dotenv";

config();

export const contactForm = async (req, res) => {
  try {
    const { fullName, phone, email, subject, message } = req.body;

    if (!fullName || !phone || !email) {
      return res
        .status(400)
        .json({ message: "Full Name, Email and Phone Number are required" });
    }

    const submissionDate = new Date().toLocaleString("en-US", {
      timeZone: "Asia/Kolkata",
      year: "numeric",
      month: "long",
      day: "numeric",
      hour: "2-digit",
      minute: "2-digit",
      second: "2-digit",
    });

    const emailSubject = `New Contact Form Submission from ${fullName}`;
    const emailContent = `
  <div style="max-width: 600px; margin: 0 auto; font-family: Arial, sans-serif; border: 1px solid #DDAC17; border-radius: 8px; overflow: hidden; background-color: #ffffff;">
    <div style="background-color: #000000; color: #ECC440; padding: 20px; text-align: center; font-size: 22px; font-weight: bold;">
      New Contact Form Submission
    </div>
    <div style="padding: 20px; background-color: #f9f9f9;">
      <p style="font-size: 16px; color: #000;"><strong style="color: #DDAC17;">Full Name:</strong> ${fullName}</p>
      <p style="font-size: 16px; color: #000;"><strong style="color: #DDAC17;">Email:</strong> ${email}</p>
      <p style="font-size: 16px; color: #000;"><strong style="color: #DDAC17;">Phone:</strong> ${phone}</p>
      <p style="font-size: 16px; color: #000;"><strong style="color: #DDAC17;">Subject:</strong> ${subject}</p>
      <p style="font-size: 16px; color: #000;"><strong style="color: #DDAC17;">Message:</strong><br>${message}</p>
      <p style="font-size: 16px; color: #000;"><strong style="color: #DDAC17;">Submission Date:</strong> ${submissionDate}</p>
    </div>
    <div style="background-color: #ECC440; color: #000; text-align: center; padding: 12px; font-size: 14px;">
      © ${new Date().getFullYear()} SKA Alliance Pvt Ltd. All rights reserved.
    </div>
  </div>
`;

    await sendEmail(
      "contact@sohiljain.com",
      emailSubject,
      emailContent,
      "Ska Alliance Enquiry"
    );

    res.status(200).json({ message: "Message Sent Successfully!" });
  } catch (error) {
    console.error("Error sending contact form:", error);
    res.status(500).json({ message: "Internal server error" });
  }
};
